implementation module EdConstants;

/*	The constants for the Editor */

from deltaSystem import HomePath;
import EdTypes;
from EdSupport import PatchableValue;
import StdEnv;

/* The version number of the compiler */

PatchableVersionString :== "#$@ABCVERSION%*&916\0";

stringToInt :: {#Char} -> Int;
stringToInt string
	=	stringToInt` 0 0
	where
	{
		length
			=	size string;
		stringToInt` i acc
			| i >= length || not (isDigit string.[i])
				=	acc;
			// otherwise
				=	stringToInt` (i+1) (acc*10 + toInt string.[i] - toInt '0');
	}

Version :: Int;
Version =: stringToInt (PatchableValue "ABCVERSION" (PatchableVersionString));

/* The name of the help and preferences files */

HelpFile			:== "Clean Help";
// RWS options: HelpFile			:== "Clean Options Help";
PrefsFile			:== "CleanPrefs";
ApplicationName		:== "CleanIDE";

/* The name of the system directory */

SystemDir			:== "Clean System Files";

/* The names of the auxilary files for the error and type window */

ErrorPathname		:== "Errors";
TypePathname		:== "Types";

/*	Default values */
/*
DefIgnoreCase				:== False;
DefBackwards				:== False;
DefWrapAround				:== True;
DefMatchWords				:== False;
DefSearchKind :== Implementation;
DefScan :== SearchImports;
DefExportsOnly :== False;
DefFindVerbose				:== True;
DefTabWidth					:== 4;
DefAutoIndent				:== True;

DefCompilerMemoryProfile	:== True;
DefCompilerTimeProfile		:== True;
DefStrictnessAnalysis		:== True;
DefTypes					:== NoTypes;
DefAttr						:== False;
DefWarnings					:== False;
DefVerbose					:== False;
DefComment					:== False;
DefReuseUniqueNodes			:== False;

DefCheckStacks				:== False;
DefCheckIndices				:== False;
DefKeepABCFile				:== False;
DefTargetProcessor			:== CurrentProcessor;

DefHeapSize					:== 409600;
DefStackSize				:== 102400;
DefExtraMem					:== 81920;
DefaultHeapSizeMultiple		:== 4096/*16*256*/;
DefaultInitialHeapSize :== 204800;
DefShowExecTime				:== False;
DefShowGCs					:== False;
DefPrintStackSize			:== False;
DefOutput					:== ShowConstructors;
DefProfile					:== False;
DefProfile601				:== False;
DefMemoryProfile			:== False;
DefMemoryProfileMinimumHeapSize :== 0;
DefWriteStderrToFile		:== False;

DefBeVerbose				:== False;
*/
/*	cursor blinking rate */

BlinkRate			:== 30;

/*	interrupt rate of interruptable processes (like Find Definition, Bring Up To Date etc.) */

InterruptRate		:== 30;

/*	text sizes */

LinesPerBlock		:== 80;

/*	Picture offsets */

PictureTop			:== -31000;	// Lowest save value
MinBottom			:== -30700;	// PictureTop + 300
PictureLeft			:== -6;
PictureRight		:== 4000;
LinesLeft			:== 0;			// Must be zero!

/*	Window constants */

FirstEditWdID			:== 4000;
NoWdID					:== 0;
HelpWdID				:== 1;
ClpbrdWdID				:== 2;
ProjectWdID				:== 3;
ErrorWdID				:== 4;
TypeWdID				:== 5;
ClpbrdWdTitle			:== "Clipboard";
ErrorWdTitle			:== "Errors";
TypeWdTitle				:== "Types";
DefWindowPos_and_Size	:== {posx=0,posy=0,sizex=500,sizey=300};
WdCorner				:== (0,0);
WdInitSize				:== (500,300);
WdMinSize				:== (70,70);
HorScroll				:== 10;
VertScroll				:== 10;

/*	Ids of the menu(item)s */

MFileID					:== 10;
	INewID				:== 101;
	IOpenID				:== 102;
	IOpDefID			:== 103;
	IOpImpID			:== 104;
	ISwapID				:== 105;
	ICloseID			:== 106;
	ISaveID				:== 107;
	ISavesID			:== 108;
	IPrintID		:== 109;
	IReverID			:== 110;
	IQuitID				:== 111;

MEditID					:== 20;
	IUndoID				:== 200;
	ICutID				:== 201;
	ICopyID				:== 202;
	IPasteID			:== 203;
	IClearID			:== 204;
	IBalanID			:== 205;
	ISelecID			:== 206;
	IFormaID			:== 207;
	IShiftLeftID		:== 208;
	IShiftRightID		:== 209;

MSearcID				:== 30;
	IFindID				:== 301;
	IFindNID			:== 302;
	IFindSID			:== 303;
	IReplaID			:== 304;
	IFindEID			:== 305;
	IFindIdID			:== 306;
	IFindDID			:== 307;
	IFindIID			:== 308;
	IGotoCID			:== 309;
	IGotoLID			:== 310;
	
MCommaID				:== 40;
	ICompiID			:== 401;
	ICheckID			:== 402;
	IGenerID			:== 403;
	IBriUDID			:== 404;
	IExecuID			:== 405;
	
MProjeID				:== 50;
	INewPrID			:== 501;
	IOpePrID			:== 502;
	ISetPrID			:== 503;
	ICloPrID			:== 504;
	IWinPrjID			:== 505;
	
MOptioID				:== 60;
	ICleanID			:== 601;
	ICodeGID			:== 602;
	IAppliID			:== 603;
	IProjeID			:== 604;
	IPathsID			:== 605;
	ILinkOptionsID	:== 606;

MWindoID				:== 70;
	INextWID			:== 701;
	IShowCID			:== 702;
	IHelpID				:== 703;
	ISaveaID			:== 704;
	IClosaID			:== 705;
	IWindoID			:== 706;


MFreeID					:== 90;		// First free menu id.
	IFreeID				:== 901;	// First free menu item id.

/*	Id's of the dialogs */

DFindID					:== 1;
DFindIdentID			:== 2;
DGotoLID				:== 3;
DTabWID					:== 4;
DSvBCID					:== 5;
DFormatID				:== 6;
DCompOptionsID			:== 7;
DCodeGenOptionsID		:== 8;
DApplOptionsID			:== 9;
DFontsID				:== 10;
DNewTypeID				:== 11;
DPathsID				:== 12;
DProjectOptionsID		:== 13;
DInfoID					:== 14;
DOpenID					:== 15;
DLinkOptionsID			:== 16;

/*	Id of the timer */

TimerID				:== 1;
TriggerID			:== 2;
InfoID				:== 3;

/*	Key constants */

	TabStr			:== "\t";
	TabChar			:== '\t';
	NewlStr			:== "\n";
	NewlChar		:== '\n';

	FirstPrintable	:== '\040';
	LastPrintable	:== '\176';
	FirstCapital	:== 'A';
	LastCapital		:== 'Z';
	FirstSmall		:== 'a';
	LastSmall		:== 'z';
	CaseOffset		:== 32;

	OutlineChars	:==	[' ', '"', '\'' ,'(' ,')' ,',' ,'.' ,':',
						 ';', '[', ']', '{', '|', '}'];

/*	Available font sizes */
    
SizesList	:: [Int];
SizesList	= [9,10,11,12,13,14,16,18,20,24];
	
DefPaths	:: List Pathname;
DefPaths	= Nil;

DefExtraObjectModules	::		   List Pathname;
DefExtraObjectModules	= Nil;

DefLibraries	::		   List Pathname;
DefLibraries	= Nil;
